/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class VWWSRRRegistryComboBoxRenderer
extends DefaultListCellRenderer {
    private final ImageIcon ICON_UNKNOWN = VWImageLoader.createImageIcon("uddiRegistryUnknown.gif");
    private final ImageIcon ICON_CONNECTED = VWImageLoader.createImageIcon("uddiRegistry.gif");
    private final ImageIcon ICON_UNREACHABLE = VWImageLoader.createImageIcon("uddiRegistryBad.gif");

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        try {
            if (value != null) {
                if (value instanceof VWWSRRRegistryItem) {
                    VWWSRRRegistryItem aEle = (VWWSRRRegistryItem)value;
                    String hostName = aEle.getHostName();
                    if (hostName == null) {
                        hostName = "";
                    }
                    this.setText(hostName);
                    int regState = aEle.getState();
                    if (regState == 1) {
                        ((JLabel)component).setIcon(this.ICON_CONNECTED);
                        ((JLabel)component).setToolTipText(VWResource.s_wsrrRegistryStateConnected);
                    } else if (regState == 2) {
                        ((JLabel)component).setIcon(this.ICON_UNREACHABLE);
                        ((JLabel)component).setToolTipText(VWResource.s_wsrrRegistryStateUnreachable);
                    } else {
                        ((JLabel)component).setIcon(this.ICON_UNKNOWN);
                        ((JLabel)component).setToolTipText(VWResource.s_wsrrRegistryStateUnknown);
                    }
                } else if (value instanceof String) {
                    ((JLabel)component).setText((String)value);
                } else {
                    ((JLabel)component).setText("");
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return component;
    }
}

